#include <bits/stdc++.h>
#define ll long long
#define endl '\n'
#define MAXN 20010
#define pii pair <ll, ll>
#define pdd pair <long double, long double>
#define EPS 1e-6

using namespace std;

struct grana
{
    ll X;
    ll Y;
    long double W;
};

vector <grana> grane;
vector <ll> DSU(MAXN);
vector <ll> SIZE(MAXN);

ll root(ll X)
{
    if(X == DSU[X]) return X;
    return DSU[X] = root(DSU[X]);
}

bool connected(ll X, ll Y)
{
    X = root(X);
    Y = root(Y);
    return (X == Y);
}

void connect(ll X, ll Y)
{
    X = root(X);
    Y = root(Y);
    if(SIZE[X] < SIZE[Y]) swap(X, Y);
    SIZE[X] += SIZE[Y];
    SIZE[Y] = 0;
    DSU[Y] = X;
}

bool cmp(const grana& A, const grana& B)
{
    if(A.W < B.W) return true;
    if(A.W > B.W) return false;
    return (A.X < B.X);
}

int main()
{
    ios_base::sync_with_stdio(false); cin.tie(0);
    long double eps;
    ll N;
    cin >> N >> eps;
    vector <long double> X(N), Y(N);
    for(ll i = 1; i <= N; i++) {DSU[i] = i; SIZE[i] = 1;}
    for(ll i = 0; i < N; i++) cin >> X[i] >> Y[i];
    if(abs(eps - 0.01) < EPS)
    {
        vector <pii> res;
        for(ll i = 0; i < N; i++)
        {
            for(ll j = i + 1; j < N; j++)
            {
                long double W = abs(X[i] - X[j]) + abs(Y[i] - Y[j]);
                grana g;
                g.X = i + 1;
                g.Y = j + 1;
                g.W = W;
                grane.push_back(g);
            }
        }
        sort(grane.begin(), grane.end(), cmp);
        for(auto g : grane)
        {
            ll X = g.X;
            ll Y = g.Y;
            if(!connected(X, Y))  {connect(X, Y); res.push_back({X, Y});}
        }
        cout << (ll) res.size() + 1 << endl;
        for(ll i = 1; i <= N; i++) cout << i << " ";
        cout << endl;
        for(auto p : res) cout << p.first << " " << p.second << endl;
    }
    else if(abs(eps - 0.2) < EPS)
    {
        vector < tuple <long double, long double, ll> > res;
        vector < vector < tuple <long double, long double, ll> > > delovi(100);
        vector < vector < pair <pdd, pdd> > > granice(10, vector <pair <pdd, pdd> >(10));
        long double lx = 0, rx = 0.1, ly = 0, ry = 0.1;
        for(ll i = 0; i < 10; i++)
        {
            lx = 0;
            rx = 0.1;
            for(ll j = 0; j < 10; j++)
            {
                granice[i][j] = {{lx, rx}, {ly, ry}};
                lx += 0.1;
                rx += 0.1;
            }
            ly += 0.1;
            ry += 0.1;
        }
        for(ll i = 0; i < 10; i++)
        {
            for(ll j = 0; j < 10; j++)
            {
                cerr << "X: " << granice[i][j].first.first << ", " << granice[i][j].first.second << endl;
                cerr << "Y: " << granice[i][j].second.first << ", " << granice[i][j].second.second << endl;
                cerr << endl;
            }
        }
        for(ll i = 0; i < N; i++)
        {
            long double x = X[i];
            long double y = Y[i];
            for(ll ii = 0; ii < 10; ii++)
            {
                for(ll jj = 0; jj < 10; jj++)
                {
                    pair <pdd, pdd> granica = granice[ii][jj];
                    lx = granica.first.first;
                    rx = granica.first.second;
                    ly = granica.second.first;
                    ry = granica.second.second;
                    if(abs(rx - 1) < EPS) rx += EPS;
                    if(abs(ry - 1) < EPS) ry += EPS;
                    ll idx = ii * 10 + jj;
                    if(x >= lx && x < rx && y >= ly && y < ry) delovi[idx].push_back(make_tuple(x, y, i + 1));
                }
            }
        }
        for(ll i = 0; i < 100; i++)
        {
            if((ll) delovi[i].size() == 0) continue;
            res.push_back(delovi[i].back());
        }
        cout << (ll) res.size() << endl;
        for(ll i = 0; i < (ll) res.size(); i++) cout << get<2>(res[i]) << " ";
        cout << endl;
        for(ll i = 0; i < (ll) res.size() - 1; i++) cout << get<2>(res[i]) << " " << get<2>(res[i + 1]) << endl;
    }
    return 0;
}